﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm



    ''' <summary>
    '''声明一个常量，用来检测在执行拖动操作期间是否按下了 Ctrl 键。
    ''' </summary>
    Const CtrlMask As Byte = 8


    ''' <summary>
    ''' 处理窗体首次加载时激发的事件。
    ''' </summary>
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '当前无法在 Visual Studio 设计器中为 PictureBox 设置 AllowDrop
        '属性，所以必须在代码中进行显式设置。
        picLeft.AllowDrop = True
        picRight.AllowDrop = True
    End Sub

    ''' <summary>
    '''处理左侧 TextBox 的 MouseDown 事件。当鼠标处于控件边界内
    '''并单击鼠标按钮时，将激发此事件。
    ''' </summary>
    Private Sub txtSource_MouseDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles txtSource.MouseDown
        If e.Button = Windows.Forms.MouseButtons.Left Then
            txtSource.SelectAll()
            '调用拖放操作。
            txtSource.DoDragDrop(txtSource.SelectedText, DragDropEffects.Move Or DragDropEffects.Copy)
        End If
    End Sub

    ''' <summary>
    ''' 处理两个 PictureBox 控件的 MouseDown 事件。当鼠标处于控件边界内 
    ''' 并单击鼠标按钮时，
    ''' 将激发此事件。
    ''' </summary>
    Private Sub PictureBox_MouseDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles picLeft.MouseDown, picRight.MouseDown
        If e.Button = Windows.Forms.MouseButtons.Left Then
            Dim pic As PictureBox = CType(sender, PictureBox)
            '调用拖放操作。
            If Not pic.Image Is Nothing Then
                pic.DoDragDrop(pic.Image, DragDropEffects.Move Or DragDropEffects.Copy)
            End If
        End If
    End Sub

    ''' <summary>
    ''' 处理两个 PictureBox 控件的 DragEnter 事件。DragEnter 是
    ''' 在将对象拖入控件边界内时激发的事件。
    ''' </summary>
    Private Sub PictureBox_DragEnter(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles picLeft.DragEnter, picRight.DragEnter
        ' 检查并确保对于此控件而言拖动的内容是正确的类型。 
        ' 否则，系统会拒绝放置。
        If (e.Data.GetDataPresent(DataFormats.Bitmap)) Then
            ' 如果在拖动操作中按着 Ctrl 键，则将执行
            ' Copy，否则会执行 Move。
            If (e.KeyState And CtrlMask) = CtrlMask Then
                e.Effect = DragDropEffects.Copy
            Else
                e.Effect = DragDropEffects.Move
            End If
        Else
            e.Effect = DragDropEffects.None
        End If
    End Sub

    ''' <summary>
    ''' 此方法处理两个 PictureBox 控件的 DragDrop 事件。一个处理程序 
    ''' 可用于两个 PictureBox 控件。Is 关键字用于查找
    ''' 选定的 PictureBox 控件的标识。
    ''' </summary>
    Private Sub PictureBox_DragDrop(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles picLeft.DragDrop, picRight.DragDrop
        '在选定的 PictureBox 控件中显示图像。
        Dim pic As PictureBox = CType(sender, PictureBox)
        pic.Image = CType(e.Data.GetData(DataFormats.Bitmap), Bitmap)

        ' 如果用户执行 Move，则将移除其他 PictureBox（即在
        ' DragDrop 事件中不是发送方的 PictureBox）中的图像。
        ' 如果未按下 Ctrl 键，则该操作为 Move。
        If (e.KeyState And CtrlMask) <> CtrlMask Then
            If sender Is picLeft Then
                picRight.Image = Nothing
            Else
                picLeft.Image = Nothing
            End If
        End If
    End Sub

    ''' <summary>
    ''' 处理两个 TreeView 控件的 DragDrop 事件。
    ''' </summary>
    Private Sub TreeView_DragDrop(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles tvwLeft.DragDrop, tvwRight.DragDrop
        ' 初始化存放用户所拖动节点的变量。
        Dim OriginationNode As TreeNode = CType(e.Data.GetData("System.Windows.Forms.TreeNode"), TreeNode)

        ' 为 TreeView 调用 GetDataPresent 与为 PictureBox
        ' 或 TextBox 控件调用该函数略有不同。TreeNode 不是 DataFormats
        '类的成员。即它不是预定义类型。GetDataPresent 的一个重载使用
        '字符串作为参数，该字符串允许您指定类型。
        If e.Data.GetDataPresent("System.Windows.Forms.TreeNode", False) Then
            Dim pt As Point
            Dim DestinationNode As TreeNode

            ' 使用 PointToClient 计算鼠标在目标
            ' TreeView 上的位置。
            pt = CType(sender, TreeView).PointToClient(New Point(e.X, e.Y))
            ' 使用此 Point 获取目标 TreeView 中最近的节点。
            DestinationNode = CType(sender, TreeView).GetNodeAt(pt)

            ' 如果用户没有直接在节点顶部放置新节点，
            ' 则 DestinationNode 将为 Nothing。
            If DestinationNode IsNot Nothing Then
                ' 如果原始节点与目标节点相同，则该节点
                ' 将消失。此代码可确保不发生这种情况。
                If Not DestinationNode.TreeView Is OriginationNode.TreeView Then
                    DestinationNode.Nodes.Add(CType(OriginationNode.Clone, TreeNode))
                    ' 添加新节点时展开父节点，以使放置操作清晰可见。
                    ' 否则，将只显示一个 + 符号。
                    DestinationNode.Expand()
                    ' 如果未按下 Ctrl 键，则移除原始节点
                    ' 以执行拖放移动。
                    If (e.KeyState And CtrlMask) <> CtrlMask Then
                        OriginationNode.Remove()
                    End If
                End If
            End If
        End If
    End Sub

    ''' <summary>
    ''' 处理两个 TreeView 控件的 DragEnter 事件。
    ''' </summary>
    Private Sub TreeView_DragEnter(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles tvwLeft.DragEnter, tvwRight.DragEnter
        ' 检查并确保对于此控件而言拖动的内容是正确的类型。 
        ' 否则，系统会拒绝放置。
        If (e.Data.GetDataPresent("System.Windows.Forms.TreeNode")) Then
            ' 如果在拖动操作中按着 Ctrl 键，则将执行
            'Copy，否则会执行 Move。
            If (e.KeyState And CtrlMask) = CtrlMask Then
                e.Effect = DragDropEffects.Copy
            Else
                e.Effect = DragDropEffects.Move
            End If
        Else
            e.Effect = DragDropEffects.None
        End If
    End Sub

    ''' <summary>
    ''' 处理两个 TreeView 控件的 ItemDrag 事件。
    ''' </summary>
    Private Sub TreeView_ItemDrag(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ItemDragEventArgs) Handles tvwLeft.ItemDrag, tvwRight.ItemDrag
        If e.Button = Windows.Forms.MouseButtons.Left Then
            '调用拖放操作
            DoDragDrop(e.Item, DragDropEffects.Move Or DragDropEffects.Copy)
        End If
    End Sub

    ''' <summary>
    ''' 处理允许放置的 TextBox 的 DragEnter 事件。DragEnter 是将
    ''' 对象拖入控件边界内时激发的事件。
    ''' </summary>
    Private Sub txtUpperRight_DragEnter(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles txtAllowDrop.DragEnter
        ' 检查并确保对于此控件而言拖动的内容是正确的类型。 
        ' 否则，系统会拒绝放置。
        If (e.Data.GetDataPresent(DataFormats.Text)) Then
            ' 如果在拖动操作中按着 Ctrl 键，则将执行
            ' Copy，否则会执行 Move。
            If (e.KeyState And CtrlMask) = CtrlMask Then
                e.Effect = DragDropEffects.Copy
            Else
                e.Effect = DragDropEffects.Move
            End If
        Else
            e.Effect = DragDropEffects.None
        End If
    End Sub

    ''' <summary>
    ''' 处理允许放置的 TextBox 的 DragDrop 事件。当释放鼠标按钮时
    ''' 将激发此事件，同时终止拖放操作。
    ''' </summary>
    Private Sub txtAllowDrop_DragDrop(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles txtAllowDrop.DragDrop
        txtAllowDrop.Text = e.Data.GetData(DataFormats.Text).ToString

        ' 如果未按下 Ctrl 键，则移除源文本以执行
        ' 拖放移动。
        If (e.KeyState And CtrlMask) <> CtrlMask Then
            txtSource.Text = ""
        End If
    End Sub


    ''' <summary>
    ''' 退出应用程序
    ''' </summary>
    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class